package cn.spatiotemporal.commons.constant;

/**
 * 
 * @ClassName: SecurityConstants    
 * @Description: 安全类常量
 * @date 2023年9月11日 上午9:19:45    
 *     
 * @author  Q.JI
 * @version  
 * @since   JDK 1.8
 */
public interface SecurityConstants {

    /**
     * 黑名单TOKEN Key前缀
     */
    String BLACKLIST_TOKEN_PREFIX = "AUTH:BLACKLIST_TOKEN:";

    /**
     * 验证码key前缀
     */
    String VERIFY_CODE_KEY_PREFIX = "AUTH:VERIFY_CODE:";

    /**
     * 短信验证码key前缀
     */
    String SMS_CODE_PREFIX = "SMS_CODE:";

    /**
     * 接口文档测试客户端ID
     */
    String TEST_CLIENT_ID = "client";

    /**
     * 系统管理 web 客户端ID
     */
    String ADMIN_CLIENT_ID = "inzy-admin";

    /**
     * 移动端（H5/Android/IOS）客户端ID
     */
    String APP_CLIENT_ID = "inzy-app";

    /**
     * 微信小程序客户端ID
     */
    String WEAPP_CLIENT_ID = "inzy-weapp";

}
