package cn.spatiotemporal.commons.base;

import java.io.Serializable;
import java.time.LocalDateTime;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;

import lombok.Data;

/**
 * 
 * @ClassName: BaseEntity
 * @Description: 基础时间
 * @date 2023年9月11日 上午9:20:44
 * 
 * @author Q.JI
 * @version
 * @since JDK 1.8
 */

@Data
public class BaseEntity implements Serializable {
	private static final long serialVersionUID = 1L;

	@JsonInclude(value = JsonInclude.Include.NON_NULL)
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	private LocalDateTime createTime;

	@JsonInclude(value = JsonInclude.Include.NON_NULL)
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	private LocalDateTime updateTime;
}
