# spatiotemporal-commons

**时空开放平台 公用组件**

包含以下三个公共组件：
- spatiotemporal-commons-core 时空开放平台 公用组件-核心包
- spatiotemporal-commons-file 时空开放平台 公用组件-文件接口服务
- spatiotemporal-commons-register 时空开放平台 公用组件-服务自注册

## 使用方法
* 在工程pom.xml文件添加以下依赖

```xml
    <dependency>
      <groupId>cn.spatiotemporal</groupId>
      <artifactId>spatiotemporal-commons-core</artifactId>
      <version>1.0.0-RELEASE</version>
    </dependency>
	<dependency>
		<groupId>cn.spatiotemporal</groupId>
		<artifactId>spatiotemporal-commons-file</artifactId>
		<version>1.0.0-RELEASE</version>
	</dependency>
	<dependency>
		<groupId>cn.spatiotemporal</groupId>
		<artifactId>spatiotemporal-commons-register</artifactId>
		<version>1.0.0-RELEASE</version>
	</dependency>
```

* 根据所选文件服务器类型，在工程yml配置文件里添加配置段。

```java
uploadservice:
##  （文件服务器类型：minio/ftp，两选一）
  type: minio   
  ## minio配置段示例
  minio:
    endpoint: http://192.168.59.120:9000
    accessKey: minioadmin
    secretKey: minioadmin123456
    bucketName: uploads
  ## ftp配置段示例
  ftp:
    host: 192.168.59.181
    port: 21
    username: ftp
    password: ftp
    requestDir: upload
    encoding: GBK
```

+ 文件上传Mapping地址为：`/api/v1/files/upload`


+ 文件删除Mapping地址为：`/api/v1/files/delete`



* 在Application启动类添加`@EnableServerRegister`注解

```java
    @EnableServerRegister(autoRegister = true, period = 60)
//参数说明：
//	autoRegister:是否启用服务自注册，false-不启用；true-启用（default true）
//	period:存续心跳，单位秒。（default 30）
```

## License
时空开放平台是一个基于[Apache 2.0 license](https://www.apache.org/licenses/LICENSE-2.0.html)发布的开源软件。

