export interface IColorObj {
    r: number;
    g: number;
    b: number;
    a?: number;
}
/**
 * 255颜色值转16进制颜色值
 * @param n 255颜色值
 * @returns hex 16进制颜色值
 */
export declare const toHex: (n: number) => string;
/**
 * 颜色对象转化为16进制颜色字符串
 * @param colorObj 颜色对象
 */
export declare const toHexString: (colorObj: IColorObj) => string;
/**
 * 颜色对象转化为rgb颜色字符串
 * @param colorObj 颜色对象
 */
export declare const toRgbString: (colorObj: IColorObj) => string;
/**
 * 颜色对象转化为rgba颜色字符串
 * @param colorObj 颜色对象
 */
export declare const toRgbaString: (colorObj: IColorObj, n?: number) => string;
/**
 * 16进制颜色字符串解析为颜色对象
 * @param color 颜色字符串
 * @returns IColorObj
 */
export declare const parseHexColor: (color: string) => IColorObj;
/**
 * rgba颜色字符串解析为颜色对象
 * @param color 颜色字符串
 * @returns IColorObj
 */
export declare const parseRgbaColor: (color: string) => IColorObj;
/**
 * 颜色字符串解析为颜色对象
 * @param color 颜色字符串
 * @returns IColorObj
 */
export declare const parseColorString: (color: string) => IColorObj;
/**
 * 颜色字符串解析为各种颜色表达方式
 * @param color 颜色字符串
 * @returns IColorObj
 */
export declare const getColorInfo: (color: string) => {
    hex: string;
    rgba: string;
    rgb: string;
    rgbaObj: IColorObj;
};
/**
 * 16进制颜色字符串转化为rgba颜色字符串
 * @param hex 16进制颜色字符串
 * @returns rgba颜色字符串
 */
export declare const hexToRgba: (hex: string) => string;
/**
 * rgba颜色字符串转化为16进制颜色字符串
 * @param rgba rgba颜色字符串
 * @returns 16进制颜色字符串
 */
export declare const rgbaToHex: (rgba: string) => string;
