import { ObjectController } from "../../modules/common/object-controller";
import { IGeoLayer } from "../../plugins/tim/entity/geoLayer-entity";
import { ITrafficFlow } from "../../plugins/tim/entity/trafficflow-entity";
import { ITrafficFlowHistory } from "../../plugins/tim/entity/trafficflowHistory-entity";
import { ITrafficFlowBoundary } from "../../plugins/tim/entity/trafficflowBoundary-entity";
import { ITrafficFlowOd } from "../../plugins/tim/entity/trafficOdFlow-entity";
import { ITrafficOdRoad } from "../../plugins/tim/entity/trafficOdRoad-entity";
import { ITrafficAnalysis } from "../../plugins/tim/entity/trafficAnalysis-entity";
import { ITrafficRoadHeatMap } from "../../plugins/tim/entity/trafficRoadHeatMap-entity";
import { ITrafficRoadNetworkHeatMap } from "../../plugins/tim/entity/trafficRoadNetworkHeatMap-entity";
import { ITimAsset } from "../../plugins/tim/entity/timAsset-entity";
import { ITrafficCam } from "../../plugins/tim/entity/trafficCam-entity";
import { ITimGlobal } from "../../plugins/tim/entity/timGlobal-entity";
export type TimAssetType = ITimAsset & ObjectController;
export type TrafficFlowType = ITrafficFlow & ObjectController;
export type TrafficFlowBoundaryType = ITrafficFlowBoundary & ObjectController;
export type TrafficFlowHistoryType = ITrafficFlowHistory & ObjectController;
export type TrafficOdFlowType = ITrafficFlowOd & ObjectController;
export type TrafficOdRoadType = ITrafficOdRoad & ObjectController;
export type TrafficAnalysisType = ITrafficAnalysis & ObjectController;
export type TrafficRoadHeatMapType = ITrafficRoadHeatMap & ObjectController;
export type TrafficRoadNetworkHeatMapType = ITrafficRoadNetworkHeatMap & ObjectController;
export type TrafficCamType = ITrafficCam & ObjectController;
export type GeoLayerType = IGeoLayer & ObjectController;
export default class TimApi {
    obj: any;
    static instance: TimApi;
    TimGlobal: ITimGlobal;
    TrafficCam: ITrafficCam;
    TimAsset: new (config: Partial<ITimAsset>) => TimAssetType;
    TrafficFlow: new (config: Partial<ITrafficFlow>) => TrafficFlowType;
    TrafficFlowHistory: new (config: Partial<ITrafficFlowHistory>) => TrafficFlowHistoryType;
    TrafficFlowBoundary: new (config: Partial<ITrafficFlowBoundary>) => TrafficFlowBoundaryType;
    TrafficOdFlow: new (config: Partial<ITrafficFlowOd>) => TrafficOdFlowType;
    TrafficOdRoad: new (config: Partial<ITrafficOdRoad>) => TrafficOdRoadType;
    TrafficAnalysis: new (config: Partial<ITrafficAnalysis>) => TrafficAnalysisType;
    TrafficRoadHeatMap: new (config: Partial<ITrafficRoadHeatMap>) => TrafficRoadHeatMapType;
    TrafficRoadNetworkHeatMap: new (config: Partial<ITrafficRoadNetworkHeatMap>) => TrafficRoadNetworkHeatMapType;
    constructor(obj?: any);
    static getInstance(): TimApi;
    private OnTrafficCamStatusChanged;
    private OnModelProcessState;
    private OnTimModelComponentClicked;
    private OnProcessControlledTrackTime;
    private OnProcessAlertBoundary;
    install(): Promise<Record<'list', any>>;
}
