import { ObjectController } from "../../../modules/common/object-controller";
import { ResultType } from '../../../../src/modules/common/data-type';
export interface ITrafficFlowHistory extends ObjectController {
    trafficDataUrl: string;
    trafficServices?: string[];
    Play: (options: any) => Promise<ResultType>;
    Pause: (options: any) => Promise<ResultType>;
    Stop: (options: any) => Promise<ResultType>;
    JumpTo: (options: any) => Promise<ResultType>;
    GetTrafficFlowInfo: (options: any) => Promise<ResultType>;
    GetAllTrafficVehicleInfo: () => Promise<ResultType>;
    GetTrafficVehicleInfo: (options: any) => Promise<ResultType>;
    RunTrafficFlowAction: (options: any) => Promise<ResultType>;
    FocusTrafficVehicles: (options: any) => Promise<ResultType>;
    GetFocusedTrafficVehicles: (options: any) => Promise<ResultType>;
    ToggleBubbles: (options: any) => Promise<ResultType>;
    ToggleSpeedBox: (options: any) => Promise<ResultType>;
    OnProcessControlledTrackTime: (res: any) => void;
}
export default class TrafficFlowHistoryClass<T extends ObjectController> {
    static extendsCore(extendsClass: new () => ObjectController): new (opt: ITrafficFlowHistory) => ObjectController;
}
