import { ObjectController } from "../../../modules/common/object-controller";
import { ResultType } from '../../../../src/modules/common/data-type';
export interface ITrafficFlow extends ObjectController {
    trafficDataUrl: string;
    trafficServices?: string[];
    GetTrafficFlowInfo: (options: any) => Promise<ResultType>;
    GetAllTrafficVehicleInfo: () => Promise<ResultType>;
    GetTrafficVehicleInfo: (options: any) => Promise<ResultType>;
    RunTrafficFlowAction: (options: any) => Promise<ResultType>;
    FocusTrafficVehicles: (options: any) => Promise<ResultType>;
    GetFocusedTrafficVehicles: (options: any) => Promise<ResultType>;
    ToggleBubbles: (options: any) => Promise<ResultType>;
    ToggleSpeedBox: (options: any) => Promise<ResultType>;
    SetBoundaryInfo: (options: any) => Promise<ResultType>;
}
export default class TrafficFlowClass<T extends ObjectController> {
    static extendsCore(extendsClass: new () => ObjectController): new (opt: ITrafficFlow) => ObjectController;
}
