import { ObjectController } from "../../../modules/common/object-controller";
import { ResultType } from "@/modules/common/data-type";
import { ITrafficCamOptions, ITrafficCamTourOptions } from "@/plugins/tim/controller/controller-trafficCam";
export interface ITrafficCam extends ObjectController {
    OnTrafficCamStatusChanged: () => void;
    FollowVehicleByClick: (options: ITrafficCamOptions) => Promise<ResultType>;
    FollowVehicleByID: (options: ITrafficCamOptions) => Promise<ResultType>;
    CancelFollowVehicle: () => Promise<ResultType>;
    LoadTrafficCameraTourData: (options: ITrafficCamTourOptions) => Promise<ResultType>;
    StartTrafficCameraTour: (options: ITrafficCamTourOptions) => Promise<ResultType>;
    UpdateTrafficCameraTour: (options: ITrafficCamTourOptions) => Promise<ResultType>;
}
