import { ObjectController } from "../../../modules/common/object-controller";
import { ResultType } from '../../../../src/modules/common/data-type';
export interface ITimAsset extends ObjectController {
    "model": {
        "sourceType": string;
        "assetId"?: number | string;
        "url"?: string;
    };
    "visibility": true;
    "location": number[];
    "rotation": number[];
    "scale": number[];
    RunTimAssetAction: (options: any) => Promise<ResultType>;
    LoadTimModelScene: (options: any) => Promise<ResultType>;
    SaveTimModelScene: (options: any) => Promise<ResultType>;
    LoadTimModelSceneOnline: (options: any) => Promise<ResultType>;
    SaveTimModelSceneOnline: (options: any) => Promise<ResultType>;
    SetCustomProperties: (options: any) => Promise<ResultType>;
    GetTimModelInfoByEid: (options: any) => Promise<ResultType>;
    ModelControl: (options: any) => Promise<ResultType>;
}
export default class TimAssetClass<T extends ObjectController> {
    static extendsCore(extendsClass: new () => ObjectController): new (opt: ITimAsset) => ObjectController;
}
