export interface ResultType {
    success: boolean;
    message?: string;
    errCode?: number;
    guid?: string;
    type?: number;
    event_name?: string;
    result?: any;
}
export interface UndoRedoResultType {
    [key: string]: Array<string>;
    addedEids: Array<string>;
    removedEids: Array<string>;
    updatedEids: Array<string>;
}
export type MinMaxType = Array<number>;
export type Coord2DType = Array<number>;
export type CoordType = Array<number>;
export interface CoordObjType {
    x?: number;
    y?: number;
    z?: number;
}
export interface RotatorType {
    pitch?: number;
    yaw?: number;
    roll?: number;
}
export interface Rotator2DType {
    pitch?: number;
    yaw?: number;
}
export type ScaleType = Array<number>;
export interface EntityEidType {
    eid?: string | null;
}
export interface EntityGeometryType {
    geometry?: any;
}
export interface PointType extends EntityEidType, Partial<BasicInfoAtomType> {
    point?: CoordType;
}
export interface PolylineType extends EntityEidType, Partial<BasicInfoAtomType> {
    polyline?: {
        points: Array<CoordType>;
    };
}
export interface LoopType {
    points: Array<CoordType>;
}
export interface PolygonLoopType {
    outerLoop?: LoopType;
    innerLoops?: Array<LoopType>;
}
export interface PolygonType extends EntityEidType, Partial<BasicInfoAtomType> {
    polygon?: PolygonLoopType;
}
export interface Loop2DType {
    points?: Array<Coord2DType>;
    curves?: Array<{
        type?: string;
        o?: Coord2DType;
        r?: number;
        s?: number;
        e?: number;
    }>;
}
export interface Polygon2DLoopType {
    outerLoop?: Loop2DType;
    innerLoops?: Array<Loop2DType>;
}
export interface Polygon2DType extends EntityEidType, Partial<BasicInfoAtomType> {
    polygon?: Polygon2DLoopType;
}
export interface HeatMapDataType extends EntityGeometryType {
    pointEntityEid?: string | null;
    value?: number;
}
export interface BasicInfoAtomType {
    entityName: string;
    customId: string;
    customData: any;
    parentEid: string;
}
export interface TransformAtomType {
    location: CoordType;
    rotator: RotatorType;
    scale3d: ScaleType;
}
export interface VisibleAtomType {
    bVisible: boolean;
}
export interface CacheAtomType {
    bRemoved: boolean;
}
export interface PointEntityAtomType {
    point: CoordType;
}
export interface Polygon2DEntityAtomType {
    polygon: Polygon2DLoopType;
}
export interface PolygonEntityAtomType {
    polygon: PolygonLoopType;
}
export interface PolylineEntityAtomType {
    polyline: {
        points: Array<CoordType>;
    };
}
export interface AssetsAtomType {
    seedIds: Array<string>;
}
export interface AssetAtomType {
    seedId: string | null;
}
export interface IVisible2D {
    camera?: {
        hideDistance?: number;
        hideType?: string;
        scaleMode?: string;
    };
    interaction?: {
        clickTop?: boolean;
        hoverTop?: boolean;
    };
}
export interface Visible2DAtomType {
    hideDistance: number;
    hideType: string;
    scaleMode: string;
    clickTop: boolean;
    hoverTop: boolean;
}
export interface IBaseData {
    BasicInfoAtom?: BasicInfoAtomType;
    TransformAtom?: TransformAtomType;
    VisibleAtom?: VisibleAtomType;
    Visible2DAtom?: Visible2DAtomType;
}
export type CoordZRefType = 'Surface' | 'Ground' | 'Altitude';
export interface ICalculateCoordZ {
    coordZRef: CoordZRefType;
    coordZOffset: number;
}
export interface IOperations {
    calculateCoordZ: ICalculateCoordZ;
}
export type ICoordinates = Array<Array<number>>;
export type ICoordinates2D = Array<Array<Array<number>>>;
export interface IPoint {
    point: Array<number>;
    value: number;
}
export interface IPolylineATom {
    coordinates: ICoordinates;
}
export interface IPolygon2DAtom {
    coordinates: ICoordinates2D;
    coordZ: number;
}
export interface IPointValueAtom {
    features: Array<IPoint>;
}
export interface IOBjectCache {
    object: Record<string, any>;
}
