import { ObjectAbstract } from '../../common/object-abstract';
import { ResultType, AssetsAtomType, BasicInfoAtomType, TransformAtomType } from '../../common/data-type';
import { TilesType, AesTilesEntityAtomType } from '../../common/interface/tiles';
import { ObjectController } from '../../common/object-controller';
declare class Tiles extends ObjectController implements ObjectAbstract {
    className: string;
    private apiClassName;
    private AesTilesEntityAtom;
    private AssetsAtom;
    private AesTilesVisualAtom;
    constructor(opt?: TilesType);
    get spaceId(): string;
    set spaceId(spaceId: string);
    get rangeBox(): Array<Array<number>>;
    set rangeBox(rangeBox: Array<Array<number>>);
    get version(): string;
    set version(version: string);
    get seedIds(): Array<string>;
    set seedIds(seedIds: Array<string>);
    GetSpaceId(): Promise<ResultType>;
    SetSpaceId(spaceId: string): Promise<ResultType>;
    GetRangeBox(): Promise<ResultType>;
    SetRangeBox(rangeBox: Array<Array<number>>): Promise<ResultType>;
    GetVersion(): Promise<ResultType>;
    SetVersion(version: string): Promise<ResultType>;
    GetSeedIds(): Promise<ResultType>;
    SetSeedIds(seedIds: Array<string>): Promise<ResultType>;
    GetScheme(): {
        AesTilesEntityAtom: AesTilesEntityAtomType;
        AssetsAtom: AssetsAtomType;
    };
    GetData(): TilesType;
    SetData(opt: TilesType): void;
    generateAtomData(opt: TilesType): {
        AesTilesEntityAtom?: Partial<AesTilesEntityAtomType>;
        BasicInfoAtom?: Partial<BasicInfoAtomType>;
        TransformAtom?: Partial<TransformAtomType>;
    };
}
export default Tiles;
