import { ObjectAbstract } from '../../common/object-abstract';
import { ResultType, BasicInfoAtomType } from '../../common/data-type';
import { WdpSceneOutlinerAtomType, SceneOutlinerType } from '../../common/interface/outliner';
import { ObjectController } from '../../common/object-controller';
declare class Outliner extends ObjectController implements ObjectAbstract {
    className: string;
    private WdpSceneOutlinerAtom;
    private entities;
    constructor(opt?: SceneOutlinerType);
    get eids(): {
        [key: string]: {
            eids: Array<string>;
        };
    };
    set eids(eids: {
        [key: string]: {
            eids: Array<string>;
        };
    });
    GetEids(): Promise<ResultType>;
    SetEids(eids: {
        [key: string]: {
            eids: Array<string>;
        };
    }): Promise<ResultType>;
    GetScheme(): {
        WdpSceneOutlinerAtom: WdpSceneOutlinerAtomType;
    };
    GetData(): SceneOutlinerType;
    SetData(opt: SceneOutlinerType): void;
    generateAtomData(opt: SceneOutlinerType): {
        WdpSceneOutlinerAtom?: Partial<WdpSceneOutlinerAtomType>;
        BasicInfoAtom?: Partial<BasicInfoAtomType>;
    };
}
export default Outliner;
