import { ObjectAbstract } from '../../../common/object-abstract';
import { ResultType, AssetAtomType, BasicInfoAtomType, TransformAtomType } from '../../../common/data-type';
import { SkeletalType, SkeletalMeshAtomType } from '../../../common/interface/skeletal';
import { ObjectController } from '../../../common/object-controller';
declare class Skeletal extends ObjectController implements ObjectAbstract {
    className: string;
    private AssetAtom;
    private SkeletalMeshAtom;
    constructor(opt?: SkeletalType);
    get seedId(): string | null;
    set seedId(seedId: string | null);
    get animSequenceIndex(): number;
    set animSequenceIndex(animSequenceIndex: number);
    get bPause(): boolean;
    set bPause(bPause: boolean);
    get bLoop(): boolean;
    set bLoop(bLoop: boolean);
    get playRate(): number;
    set playRate(playRate: number);
    get playInterval(): {
        min: number;
        max: number;
    };
    set playInterval(playInterval: {
        min: number;
        max: number;
    });
    GetSeedId(): Promise<ResultType>;
    SetSeedId(seedId: string | null): Promise<ResultType>;
    GetAnimSequenceIndex(): Promise<ResultType>;
    SetAnimSequenceIndex(animSequenceIndex: number): Promise<ResultType>;
    GetbPause(): Promise<ResultType>;
    SetbPause(bPause: boolean): Promise<ResultType>;
    GetbLoop(): Promise<ResultType>;
    SetbLoop(bLoop: boolean): Promise<ResultType>;
    GetPlayRate(): Promise<ResultType>;
    SetPlayRate(playRate: number): Promise<ResultType>;
    GetPlayInterval(): Promise<ResultType>;
    SetPlayInterval(playInterval: {
        min: number;
        max: number;
    }): Promise<ResultType>;
    GetScheme(): {
        AssetAtom: AssetAtomType;
        SkeletalMeshAtom: SkeletalMeshAtomType;
    };
    GetData(): SkeletalType;
    SetData(opt: SkeletalType): void;
    generateAtomData(opt: SkeletalType): {
        SkeletalMeshAtom?: Partial<SkeletalMeshAtomType>;
        AssetAtom?: Partial<AssetAtomType>;
        BasicInfoAtom?: Partial<BasicInfoAtomType>;
        TransformAtom?: Partial<TransformAtomType>;
    };
}
export default Skeletal;
