import { ObjectAbstract } from '../../../common/object-abstract';
import { ResultType, AssetAtomType, BasicInfoAtomType, TransformAtomType } from '../../../common/data-type';
import { MaterialAtomType, IMaterial } from '../../../common/interface/material';
import { HierarchyType } from '../../../common/interface/hierarchy';
import { ObjectController } from '../../../common/object-controller';
declare class Hierarchy extends ObjectController implements ObjectAbstract {
    className: string;
    private AssetAtom;
    private MaterialAtom;
    constructor(opt?: HierarchyType);
    get seedId(): string | null;
    set seedId(seedId: string | null);
    get changedMaterialInfo(): Array<IMaterial>;
    set changedMaterialInfo(changedMaterialInfo: Array<IMaterial>);
    GetSeedId(): Promise<ResultType>;
    SetSeedId(seedId: string | null): Promise<ResultType>;
    GetChangedMaterialInfo(): Promise<ResultType>;
    SetChangedMaterialInfo(changedMaterialInfo: Array<IMaterial>): Promise<ResultType>;
    GetScheme(): {
        AssetAtom: AssetAtomType;
        MaterialAtom: MaterialAtomType;
    };
    GetData(): HierarchyType;
    SetData(opt: HierarchyType): void;
    generateAtomData(opt: HierarchyType): {
        AssetAtom?: Partial<AssetAtomType>;
        BasicInfoAtom?: Partial<BasicInfoAtomType>;
        TransformAtom?: Partial<TransformAtomType>;
    };
}
export default Hierarchy;
