import { ObjectAbstract } from '../../common/object-abstract';
import { ResultType, BasicInfoAtomType, TransformAtomType, VisibleAtomType, CoordType, RotatorType, ScaleType } from '../../common/data-type';
import { GroupType, EntityChildrenAtomType } from '../../common/interface/group';
import { ObjectController } from '../../common/object-controller';
declare class Group extends ObjectController implements ObjectAbstract {
    className: string;
    private apiClassName;
    private EntityChildrenAtom;
    private childrenEntities;
    private WdpGroupTransformAtom;
    private WdpGroupVisibleAtom;
    constructor(opt?: GroupType);
    get bVisible(): boolean;
    set bVisible(bVisible: boolean);
    get location(): CoordType;
    set location(location: CoordType);
    get rotator(): RotatorType;
    set rotator(rotator: RotatorType);
    get scale3d(): ScaleType;
    set scale3d(scale3d: ScaleType);
    get childrenEids(): Array<string>;
    set childrenEids(childrenEids: Array<string>);
    get children(): Array<any>;
    set children(childrenEntities: Array<any>);
    getChildren(): Promise<ResultType>;
    setChildren(childrenEntities: Array<any>): Promise<ResultType>;
    GetVisible(): Promise<ResultType>;
    SetVisible(bVisible?: boolean): Promise<ResultType>;
    GetLocation(): Promise<ResultType>;
    SetLocation(location: CoordType): Promise<ResultType>;
    GetRotator(): Promise<ResultType>;
    SetRotator(rotator: RotatorType): Promise<ResultType>;
    GetScale3d(): Promise<ResultType>;
    SetScale3d(scale3d: ScaleType): Promise<ResultType>;
    GetScheme(): {
        EntityChildrenAtom: EntityChildrenAtomType;
    };
    GetData(): GroupType;
    SetData(opt: GroupType): void;
    generateAtomData(opt: GroupType): {
        EntityChildrenAtom?: Partial<EntityChildrenAtomType>;
        BasicInfoAtom?: Partial<BasicInfoAtomType>;
        WdpGroupTransformAtom?: Partial<TransformAtomType>;
        WdpGroupVisibleAtom?: Partial<VisibleAtomType>;
    };
    generateLocationAtom(location: CoordType): any;
    generateRotatorAtom(rotator: RotatorType): any;
    generateScale3dAtom(scale3d: ScaleType): any;
    generateVisibleAtom(bVisible: boolean): any;
    UnGroup(): Promise<ResultType>;
    Add(objs: Array<Record<string, any>>, addToGroupPosition?: number): Promise<ResultType>;
}
export default Group;
