import { ObjectAbstract } from '../../../common/object-abstract';
import { ResultType, MinMaxType, Coord2DType, BasicInfoAtomType, TransformAtomType } from '../../../common/data-type';
import { WindowType, WindowEntityAtomType } from '../../../common/interface/window';
import { ObjectController } from '../../../common/object-controller';
declare class Poi extends ObjectController implements ObjectAbstract {
    className: string;
    private apiClassName;
    private WindowEntityAtom;
    constructor(opt?: WindowType);
    get url(): string;
    set url(url: string);
    get size(): MinMaxType;
    set size(size: MinMaxType);
    get offset(): Coord2DType;
    set offset(offset: Coord2DType);
    GetUrl(): Promise<ResultType>;
    SetUrl(url: string): Promise<ResultType>;
    GetSize(): Promise<ResultType>;
    SetSize(size: MinMaxType): Promise<ResultType>;
    GetOffset(): Promise<ResultType>;
    SetOffset(offset: Coord2DType): Promise<ResultType>;
    GetScheme(): {
        WindowEntityAtom: WindowEntityAtomType;
    };
    GetData(): WindowType;
    SetData(opt: WindowType): void;
    generateAtomData(opt: WindowType): {
        WindowEntityAtom?: Partial<WindowEntityAtomType>;
        BasicInfoAtom?: Partial<BasicInfoAtomType>;
        TransformAtom?: Partial<TransformAtomType>;
    };
}
export default Poi;
