import { ObjectAbstract } from '../../../common/object-abstract';
import { ResultType, BasicInfoAtomType, TransformAtomType } from '../../../common/data-type';
import { ViewshedType, ViewShedEntityAtomType } from '../../../common/interface/viewshed';
import { ObjectController } from '../../../common/object-controller';
declare class Viewshed extends ObjectController implements ObjectAbstract {
    className: string;
    private ViewShedEntityAtom;
    constructor(opt?: ViewshedType);
    get visibleColor(): string;
    set visibleColor(visibleColor: string);
    get hiddenColor(): string;
    set hiddenColor(hiddenColor: string);
    get outline(): boolean;
    set outline(outline: boolean);
    get fieldOfView(): number;
    set fieldOfView(fieldOfView: number);
    get radius(): number;
    set radius(radius: number);
    GetVisibleColor(): Promise<ResultType>;
    SetVisibleColor(visibleColor: string): Promise<ResultType>;
    GetHiddenColor(): Promise<ResultType>;
    SetHiddenColor(hiddenColor: string): Promise<ResultType>;
    GetOutline(): Promise<ResultType>;
    SetOutline(outline: boolean): Promise<ResultType>;
    GetFieldOfView(): Promise<ResultType>;
    SetFieldOfView(fieldOfView: number): Promise<ResultType>;
    GetRadius(): Promise<ResultType>;
    SetRadius(radius: number): Promise<ResultType>;
    GetScheme(): {
        ViewShedEntityAtom: ViewShedEntityAtomType;
    };
    GetData(): ViewshedType;
    SetData(opt: ViewshedType): void;
    generateAtomData(opt: ViewshedType): {
        ViewShedEntityAtom?: Partial<ViewShedEntityAtomType>;
        BasicInfoAtom?: Partial<BasicInfoAtomType>;
        TransformAtom?: Partial<TransformAtomType>;
    };
}
export default Viewshed;
