import { ObjectAbstract } from '../../../common/object-abstract';
import { ResultType, BasicInfoAtomType, TransformAtomType } from '../../../common/data-type';
import { Text3DType, Text3DEntityAtomType } from '../../../common/interface/text3d';
import { ObjectController } from '../../../common/object-controller';
declare class Text3D extends ObjectController implements ObjectAbstract {
    className: string;
    private Text3DEntityAtom;
    constructor(opt?: Text3DType);
    get text(): string;
    set text(text: string);
    get color(): string;
    set color(color: string);
    get sType(): string;
    set sType(type: string);
    get outline(): number;
    set outline(outline: number);
    get portrait(): boolean;
    set portrait(portrait: boolean);
    get space(): number;
    set space(space: number);
    get bounce(): number;
    set bounce(bounce: number);
    GetText(): Promise<ResultType>;
    SetText(text: string): Promise<ResultType>;
    GetColor(): Promise<ResultType>;
    SetColor(color: string): Promise<ResultType>;
    GetsType(): Promise<ResultType>;
    SetsType(type: string): Promise<ResultType>;
    GetOutline(): Promise<ResultType>;
    SetOutline(outline: number): Promise<ResultType>;
    GetPortrait(): Promise<ResultType>;
    SetPortrait(portrait: boolean): Promise<ResultType>;
    GetSpace(): Promise<ResultType>;
    SetSpace(space: number): Promise<ResultType>;
    GetBounce(): Promise<ResultType>;
    SetBounce(bounce: number): Promise<ResultType>;
    GetScheme(): {
        Text3DEntityAtom: Text3DEntityAtomType;
    };
    GetData(): Text3DType;
    SetData(opt: Text3DType): void;
    generateAtomData(opt: Text3DType): {
        Text3DEntityAtom?: Partial<Text3DEntityAtomType>;
        BasicInfoAtom?: Partial<BasicInfoAtomType>;
        TransformAtom?: Partial<TransformAtomType>;
    };
}
export default Text3D;
