import { ObjectAbstract } from '../../../common/object-abstract';
import { ResultType, BasicInfoAtomType, IPointValueAtom, IPoint } from '../../../common/data-type';
import { SpaceHeatMapType, SpaceHeatMapEntityAtomType } from '../../../common/interface/spaceheatmap';
import { ObjectController } from '../../../common/object-controller';
declare class SpaceHeatMap extends ObjectController implements ObjectAbstract {
    className: string;
    private SpaceHeatMapEntityAtom;
    private PointValueAtom;
    constructor(opt?: SpaceHeatMapType);
    get brushDiameter(): number;
    set brushDiameter(brushDiameter: number);
    get mappingValueRange(): Array<number>;
    set mappingValueRange(mappingValueRange: Array<number>);
    get gradientSetting(): Array<string>;
    set gradientSetting(gradientSetting: Array<string>);
    get features(): Array<IPoint>;
    set features(features: Array<IPoint>);
    GetBrushDiameter(): Promise<ResultType>;
    SetBrushDiameter(brushDiameter: number): Promise<ResultType>;
    GetMappingValueRange(): Promise<ResultType>;
    SetMappingValueRange(mappingValueRange: Array<number>): Promise<ResultType>;
    GetGradientSetting(): Promise<ResultType>;
    SetGradientSetting(gradientSetting: Array<string>): Promise<ResultType>;
    GetFeatures(): Promise<ResultType>;
    SetFeatures(features: Array<IPoint>): Promise<ResultType>;
    GetScheme(): {
        SpaceHeatMapEntityAtom: SpaceHeatMapEntityAtomType;
        PointValueAtom: IPointValueAtom;
    };
    GetData(): SpaceHeatMapType;
    SetData(opt: SpaceHeatMapType): void;
    generateAtomData(opt: SpaceHeatMapType): {
        SpaceHeatMapEntityAtom?: Partial<SpaceHeatMapEntityAtomType>;
        BasicInfoAtom?: Partial<BasicInfoAtomType>;
        PointValueAtom?: Partial<IPointValueAtom>;
    };
}
export default SpaceHeatMap;
