import { ObjectAbstract } from '../../../common/object-abstract';
import { ResultType, BasicInfoAtomType, IPointValueAtom, IPoint } from '../../../common/data-type';
import { RoadHeatMapType, RoadHeatMapEntityAtomType } from '../../../common/interface/roadheatmap';
import { ObjectController } from '../../../common/object-controller';
declare class RoadHeatMap extends ObjectController implements ObjectAbstract {
    className: string;
    private RoadHeatMapEntityAtom;
    private PointValueAtom;
    constructor(opt?: RoadHeatMapType);
    get sType(): string;
    set sType(type: string);
    get width(): number;
    set width(width: number);
    get mappingValueRange(): Array<number>;
    set mappingValueRange(mappingValueRange: Array<number>);
    get gradientSetting(): Array<string>;
    set gradientSetting(gradientSetting: Array<string>);
    get filter(): Array<string>;
    set filter(filter: Array<string>);
    get features(): Array<IPoint>;
    set features(features: Array<IPoint>);
    GetsType(): Promise<ResultType>;
    SetsType(type: string): Promise<ResultType>;
    GetWidth(): Promise<ResultType>;
    SetWidth(width: number): Promise<ResultType>;
    GetMappingValueRange(): Promise<ResultType>;
    SetMappingValueRange(mappingValueRange: Array<number>): Promise<ResultType>;
    GetGradientSetting(): Promise<ResultType>;
    SetGradientSetting(gradientSetting: Array<string>): Promise<ResultType>;
    GetFilter(): Promise<ResultType>;
    SetFilter(filter: Array<string>): Promise<ResultType>;
    GetFeatures(): Promise<ResultType>;
    SetFeatures(features: Array<IPoint>): Promise<ResultType>;
    GetScheme(): {
        RoadHeatMapEntityAtom: RoadHeatMapEntityAtomType;
        PointValueAtom: IPointValueAtom;
    };
    GetData(): RoadHeatMapType;
    SetData(opt: RoadHeatMapType): void;
    generateAtomData(opt: RoadHeatMapType): {
        RoadHeatMapEntityAtom?: Partial<RoadHeatMapEntityAtomType>;
        BasicInfoAtom?: Partial<BasicInfoAtomType>;
        PointValueAtom?: Partial<IPointValueAtom>;
    };
}
export default RoadHeatMap;
