import { ObjectAbstract } from '../../../common/object-abstract';
import { ResultType, MinMaxType, Coord2DType, BasicInfoAtomType, TransformAtomType } from '../../../common/data-type';
import { RealTimeVideoType, RealTimeVideoEntityAtomType } from '../../../common/interface/realtime-video';
import { ObjectController } from '../../../common/object-controller';
declare class RealTimeVideo extends ObjectController implements ObjectAbstract {
    className: string;
    private RealTimeVideoEntityAtom;
    constructor(opt?: RealTimeVideoType);
    get url(): string;
    set url(url: string);
    get resolution(): MinMaxType;
    set resolution(resolution: MinMaxType);
    get offset(): Coord2DType;
    set offset(offset: Coord2DType);
    get state(): string;
    set state(state: string);
    GetUrl(): Promise<ResultType>;
    SetUrl(url: string): Promise<ResultType>;
    GetResolution(): Promise<ResultType>;
    SetResolution(resolution: MinMaxType): Promise<ResultType>;
    GetOffset(): Promise<ResultType>;
    SetOffset(offset: Coord2DType): Promise<ResultType>;
    GetState(): Promise<ResultType>;
    SetState(state: string): Promise<ResultType>;
    GetScheme(): {
        RealTimeVideoEntityAtom: RealTimeVideoEntityAtomType;
    };
    GetData(): RealTimeVideoType;
    SetData(opt: RealTimeVideoType): void;
    generateAtomData(opt: RealTimeVideoType): {
        RealTimeVideoEntityAtom?: Partial<RealTimeVideoEntityAtomType>;
        BasicInfoAtom?: Partial<BasicInfoAtomType>;
        TransformAtom?: Partial<TransformAtomType>;
    };
}
export default RealTimeVideo;
