import { ObjectAbstract } from '../../../common/object-abstract';
import { ResultType, BasicInfoAtomType, TransformAtomType } from '../../../common/data-type';
import { RasterType, RasterEntityAtomType } from '../../../common/interface/raster';
import { ObjectController } from '../../../common/object-controller';
declare class Raster extends ObjectController implements ObjectAbstract {
    className: string;
    private RasterEntityAtom;
    constructor(opt?: RasterType);
    get path(): string;
    set path(path: string);
    get sType(): string;
    set sType(type: string);
    get gradientSetting(): Array<string>;
    set gradientSetting(gradientSetting: Array<string>);
    GetPath(): Promise<ResultType>;
    SetPath(path: string): Promise<ResultType>;
    GetsType(): Promise<ResultType>;
    SetsType(type: string): Promise<ResultType>;
    GetGradientSetting(): Promise<ResultType>;
    SetGradientSetting(gradientSetting: Array<string>): Promise<ResultType>;
    GetScheme(): {
        RasterEntityAtom: RasterEntityAtomType;
    };
    GetData(): RasterType;
    SetData(opt: RasterType): void;
    generateAtomData(opt: RasterType): {
        RasterEntityAtom?: Partial<RasterEntityAtomType>;
        BasicInfoAtom?: Partial<BasicInfoAtomType>;
        TransformAtom?: Partial<TransformAtomType>;
    };
}
export default Raster;
