import { ObjectAbstract } from '../../../common/object-abstract';
import { ResultType, BasicInfoAtomType, IPolygon2DAtom, ICoordinates2D } from '../../../common/data-type';
import { RangeType, RangeEntityAtomType } from '../../../common/interface/range';
import { ObjectController } from '../../../common/object-controller';
declare class Range extends ObjectController implements ObjectAbstract {
    className: string;
    private RangeEntityAtom;
    private Polygon2DAtom;
    constructor(opt?: RangeType);
    get sType(): string;
    set sType(type: string);
    get fillAreaType(): string;
    set fillAreaType(fillAreaType: string);
    get height(): number;
    set height(height: number);
    get strokeWeight(): number;
    set strokeWeight(strokeWeight: number);
    get color(): string;
    set color(color: string);
    get coordinates(): ICoordinates2D;
    set coordinates(coordinates: ICoordinates2D);
    get coordZ(): number;
    set coordZ(coordZ: number);
    GetsType(): Promise<ResultType>;
    SetsType(type: string): Promise<ResultType>;
    GetFillAreaType(): Promise<ResultType>;
    SetFillAreaType(fillAreaType: string): Promise<ResultType>;
    GetHeight(): Promise<ResultType>;
    SetHeight(height: number): Promise<ResultType>;
    GetStrokeWeight(): Promise<ResultType>;
    SetStrokeWeight(strokeWeight: number): Promise<ResultType>;
    GetColor(): Promise<ResultType>;
    SetColor(color: string): Promise<ResultType>;
    GetCoordinates(): Promise<ResultType>;
    SetCoordinates(coordinates: ICoordinates2D): Promise<ResultType>;
    GetCoordZ(): Promise<ResultType>;
    SetCoordZ(coordZ: number): Promise<ResultType>;
    GetScheme(): {
        RangeEntityAtom: RangeEntityAtomType;
        Polygon2DAtom: IPolygon2DAtom;
    };
    GetData(): RangeType;
    SetData(opt: RangeType): void;
    generateAtomData(opt: RangeType): {
        RangeEntityAtom?: Partial<RangeEntityAtomType>;
        BasicInfoAtom?: Partial<BasicInfoAtomType>;
        Polygon2DAtom?: Partial<IPolygon2DAtom>;
    };
}
export default Range;
