import { ObjectAbstract } from '../../../common/object-abstract';
import { ResultType, MinMaxType, Coord2DType, BasicInfoAtomType, TransformAtomType } from '../../../common/data-type';
import { PoiType, PoiEntityAtomType } from '../../../common/interface/poi';
import { ObjectController } from '../../../common/object-controller';
declare class Poi extends ObjectController implements ObjectAbstract {
    className: string;
    private PoiEntityAtom;
    constructor(opt?: PoiType);
    get markerSize(): MinMaxType;
    set markerSize(markerSize: MinMaxType);
    get markerNormalUrl(): string;
    set markerNormalUrl(markerNormalUrl: string);
    get markerActivateUrl(): string;
    set markerActivateUrl(markerActivateUrl: string);
    get labelBgImageUrl(): string;
    set labelBgImageUrl(labelBgImageUrl: string);
    get labelBgSize(): MinMaxType;
    set labelBgSize(labelBgSize: MinMaxType);
    get labelBgOffset(): Coord2DType;
    set labelBgOffset(labelBgOffset: Coord2DType);
    get labelContent(): Array<string>;
    set labelContent(labelContent: Array<string>);
    GetMarkerSize(): Promise<ResultType>;
    SetMarkerSize(markerSize: MinMaxType): Promise<ResultType>;
    GetMarkerNormalUrl(): Promise<ResultType>;
    SetMarkerNormalUrl(markerNormalUrl: string): Promise<ResultType>;
    GetMarkerActivateUrl(): Promise<ResultType>;
    SetMarkerActivateUrl(markerActivateUrl: string): Promise<ResultType>;
    GetLabelBgImageUrl(): Promise<ResultType>;
    SetLabelBgImageUrl(labelBgImageUrl: string): Promise<ResultType>;
    GetLabelBgSize(): Promise<ResultType>;
    SetLabelBgSize(labelBgSize: MinMaxType): Promise<ResultType>;
    GetLabelBgOffset(): Promise<ResultType>;
    SetLabelBgOffset(labelBgOffset: Coord2DType): Promise<ResultType>;
    GetLabelContent(): Promise<ResultType>;
    SetLabelContent(labelContent: Array<string>): Promise<ResultType>;
    GetScheme(): {
        PoiEntityAtom: PoiEntityAtomType;
    };
    GetData(): PoiType;
    SetData(opt: PoiType): void;
    generateAtomData(opt: PoiType): {
        PoiEntityAtom?: Partial<PoiEntityAtomType>;
        BasicInfoAtom?: Partial<BasicInfoAtomType>;
        TransformAtom?: Partial<TransformAtomType>;
    };
}
export default Poi;
