import { ObjectAbstract } from '../../../common/object-abstract';
import { ResultType, BasicInfoAtomType, IPolylineATom, ICoordinates } from '../../../common/data-type';
import { PathType, PathEntityAtomType } from '../../../common/interface/path';
import { ObjectController } from '../../../common/object-controller';
declare class Path extends ObjectController implements ObjectAbstract {
    className: string;
    private PathEntityAtom;
    private PolylineAtom;
    constructor(opt?: PathType);
    get sType(): string;
    set sType(type: string);
    get width(): number;
    set width(width: number);
    get color(): string;
    set color(color: string);
    get passColor(): string;
    set passColor(passColor: string);
    get coordinates(): ICoordinates;
    set coordinates(coordinates: ICoordinates);
    GetsType(): Promise<ResultType>;
    SetsType(type: string): Promise<ResultType>;
    GetWidth(): Promise<ResultType>;
    SetWidth(width: number): Promise<ResultType>;
    GetColor(): Promise<ResultType>;
    SetColor(color: string): Promise<ResultType>;
    GetPassColor(): Promise<ResultType>;
    SetPassColor(passColor: string): Promise<ResultType>;
    GetCoordinates(): Promise<ResultType>;
    SetCoordinates(coordinates: ICoordinates): Promise<ResultType>;
    GetScheme(): {
        PathEntityAtom: PathEntityAtomType;
        PolylineAtom: IPolylineATom;
    };
    GetData(): PathType;
    SetData(opt: PathType): void;
    generateAtomData(opt: PathType): {
        PathEntityAtom?: Partial<PathEntityAtomType>;
        BasicInfoAtom?: Partial<BasicInfoAtomType>;
        PolylineAtom?: Partial<IPolylineATom>;
    };
}
export default Path;
