import { ObjectAbstract } from '../../../common/object-abstract';
import { ResultType, BasicInfoAtomType, TransformAtomType } from '../../../common/data-type';
import { ParticleType, ParticleEntityAtomType } from '../../../common/interface/particle';
import { ObjectController } from '../../../common/object-controller';
declare class Particle extends ObjectController implements ObjectAbstract {
    className: string;
    private ParticleEntityAtom;
    constructor(opt?: ParticleType);
    get particleType(): string;
    set particleType(particleType: string);
    GetParticleType(): Promise<ResultType>;
    SetParticleType(particleType: string): Promise<ResultType>;
    GetScheme(): {
        ParticleEntityAtom: ParticleEntityAtomType;
    };
    GetData(): ParticleType;
    SetData(opt: ParticleType): void;
    generateAtomData(opt: ParticleType): {
        ParticleEntityAtom?: Partial<ParticleEntityAtomType>;
        BasicInfoAtom?: Partial<BasicInfoAtomType>;
        TransformAtom?: Partial<TransformAtomType>;
    };
}
export default Particle;
