import { ObjectAbstract } from '../../../common/object-abstract';
import { ResultType, BasicInfoAtomType, IPolylineATom, ICoordinates } from '../../../common/data-type';
import { ParabolaType, ParabolaEntityAtomType } from '../../../common/interface/parabola';
import { ObjectController } from '../../../common/object-controller';
declare class Parabola extends ObjectController implements ObjectAbstract {
    className: string;
    private ParabolaEntityAtom;
    private PolylineAtom;
    constructor(opt?: ParabolaType);
    get sType(): string;
    set sType(type: string);
    get topHeight(): number;
    set topHeight(topHeight: number);
    get topScale(): number;
    set topScale(topScale: number);
    get width(): number;
    set width(width: number);
    get color(): string;
    set color(color: string);
    get gather(): boolean;
    set gather(gather: boolean);
    get coordinates(): ICoordinates;
    set coordinates(coordinates: ICoordinates);
    GetsType(): Promise<ResultType>;
    SetsType(type: string): Promise<ResultType>;
    GetTopHeight(): Promise<ResultType>;
    SetTopHeight(topHeight: number): Promise<ResultType>;
    GetTopScale(): Promise<ResultType>;
    SetTopScale(topScale: number): Promise<ResultType>;
    GetWidth(): Promise<ResultType>;
    SetWidth(width: number): Promise<ResultType>;
    GetColor(): Promise<ResultType>;
    SetColor(color: string): Promise<ResultType>;
    GetGather(): Promise<ResultType>;
    SetGather(gather: boolean): Promise<ResultType>;
    GetCoordinates(): Promise<ResultType>;
    SetCoordinates(coordinates: ICoordinates): Promise<ResultType>;
    GetScheme(): {
        ParabolaEntityAtom: ParabolaEntityAtomType;
        PolylineAtom: IPolylineATom;
    };
    GetData(): ParabolaType;
    SetData(opt: ParabolaType): void;
    generateAtomData(opt: ParabolaType): {
        ParabolaEntityAtom?: Partial<ParabolaEntityAtomType>;
        BasicInfoAtom?: Partial<BasicInfoAtomType>;
        PolylineAtom?: Partial<IPolylineATom>;
    };
}
export default Parabola;
