import { ObjectAbstract } from '../../../common/object-abstract';
import { ResultType, BasicInfoAtomType, IPolygon2DAtom, ICoordinates2D } from '../../../common/data-type';
import { HighlightAreaType, HighlightAreaEntityAtomType } from '../../../common/interface/highlightarea';
import { ObjectController } from '../../../common/object-controller';
declare class HighlightArea extends ObjectController implements ObjectAbstract {
    className: string;
    private HighlightAreaEntityAtom;
    private Polygon2DAtom;
    constructor(opt?: HighlightAreaType);
    get interiorColor(): string;
    set interiorColor(interiorColor: string);
    get exteriorColor(): string;
    set exteriorColor(exteriorColor: string);
    get exteriorOutlineColor(): string;
    set exteriorOutlineColor(exteriorOutlineColor: string);
    get exteriorSaturation(): number;
    set exteriorSaturation(exteriorSaturation: number);
    get exteriorBrightness(): number;
    set exteriorBrightness(exteriorBrightness: number);
    get exteriorContrast(): number;
    set exteriorContrast(exteriorContrast: number);
    get coordinates(): ICoordinates2D;
    set coordinates(coordinates: ICoordinates2D);
    get coordZ(): number;
    set coordZ(coordZ: number);
    GetInteriorColor(): Promise<ResultType>;
    SetInteriorColor(interiorColor: string): Promise<ResultType>;
    GetExteriorColor(): Promise<ResultType>;
    SetExteriorColor(exteriorColor: string): Promise<ResultType>;
    GetExteriorOutlineColor(): Promise<ResultType>;
    SetExteriorOutlineColor(exteriorOutlineColor: string): Promise<ResultType>;
    GetExteriorSaturation(): Promise<ResultType>;
    SetExteriorSaturation(exteriorSaturation: number): Promise<ResultType>;
    GetExteriorBrightness(): Promise<ResultType>;
    SetExteriorBrightness(exteriorBrightness: number): Promise<ResultType>;
    GetExteriorContrast(): Promise<ResultType>;
    SetExteriorContrast(exteriorContrast: number): Promise<ResultType>;
    GetCoordinates(): Promise<ResultType>;
    SetCoordinates(coordinates: ICoordinates2D): Promise<ResultType>;
    GetCoordZ(): Promise<ResultType>;
    SetCoordZ(coordZ: number): Promise<ResultType>;
    GetScheme(): {
        HighlightAreaEntityAtom: HighlightAreaEntityAtomType;
        Polygon2DAtom: IPolygon2DAtom;
    };
    GetData(): HighlightAreaType;
    SetData(opt: HighlightAreaType): void;
    generateAtomData(opt: HighlightAreaType): {
        HighlightAreaEntityAtom?: Partial<HighlightAreaEntityAtomType>;
        BasicInfoAtom?: Partial<BasicInfoAtomType>;
        Polygon2DAtom?: Partial<IPolygon2DAtom>;
    };
}
export default HighlightArea;
