import { ObjectAbstract } from '../../../common/object-abstract';
import { ResultType, BasicInfoAtomType, IPointValueAtom, IPoint, ICoordinates } from '../../../common/data-type';
import { HeatMapType, HeatMapEntityAtomType } from '../../../common/interface/heatmap';
import { ObjectController } from '../../../common/object-controller';
declare class HeatMap extends ObjectController implements ObjectAbstract {
    className: string;
    private apiClassName;
    private HeatMapEntityAtom;
    private PointValueAtom;
    constructor(opt?: HeatMapType);
    get sType(): string;
    set sType(type: string);
    get brushDiameter(): number;
    set brushDiameter(brushDiameter: number);
    get mappingValueRange(): Array<number>;
    set mappingValueRange(mappingValueRange: Array<number>);
    get gradientSetting(): Array<string>;
    set gradientSetting(gradientSetting: Array<string>);
    get features(): Array<IPoint>;
    set features(features: Array<IPoint>);
    GetsType(): Promise<ResultType>;
    SetsType(type: string): Promise<ResultType>;
    GetBrushDiameter(): Promise<ResultType>;
    SetBrushDiameter(brushDiameter: number): Promise<ResultType>;
    GetMappingValueRange(): Promise<ResultType>;
    SetMappingValueRange(mappingValueRange: Array<number>): Promise<ResultType>;
    GetGradientSetting(): Promise<ResultType>;
    SetGradientSetting(gradientSetting: Array<string>): Promise<ResultType>;
    GetFeatures(): Promise<ResultType>;
    SetFeatures(features: Array<IPoint>): Promise<ResultType>;
    GetScheme(): {
        HeatMapEntityAtom: HeatMapEntityAtomType;
        PointValueAtom: IPointValueAtom;
    };
    GetData(): HeatMapType;
    SetData(opt: HeatMapType): void;
    generateAtomData(opt: HeatMapType): {
        HeatMapEntityAtom?: Partial<HeatMapEntityAtomType>;
        BasicInfoAtom?: Partial<BasicInfoAtomType>;
        PointValueAtom?: Partial<IPointValueAtom>;
    };
    Clip(polygon: ICoordinates, color?: string): Promise<ResultType>;
    UnClip(): Promise<ResultType>;
}
export default HeatMap;
