import { ObjectAbstract } from '../../../common/object-abstract';
import { ResultType, BasicInfoAtomType, IPointValueAtom, IPoint, ICoordinates } from '../../../common/data-type';
import { ColumnarHeatMapType, ColumnarHeatMapEntityAtomType } from '../../../common/interface/columnarheatmap';
import { ObjectController } from '../../../common/object-controller';
declare class ColumnarHeatMap extends ObjectController implements ObjectAbstract {
    className: string;
    private apiClassName;
    private ColumnarHeatMapEntityAtom;
    private PointValueAtom;
    constructor(opt?: ColumnarHeatMapType);
    get sType(): string;
    set sType(type: string);
    get brushDiameter(): number;
    set brushDiameter(brushDiameter: number);
    get mappingValueRange(): Array<number>;
    set mappingValueRange(mappingValueRange: Array<number>);
    get columnarWidth(): number;
    set columnarWidth(columnarWidth: number);
    get mappingHeightRange(): Array<number>;
    set mappingHeightRange(mappingHeightRange: Array<number>);
    get enableGap(): boolean;
    set enableGap(enableGap: boolean);
    get gradientSetting(): Array<string>;
    set gradientSetting(gradientSetting: Array<string>);
    get features(): Array<IPoint>;
    set features(features: Array<IPoint>);
    GetsType(): Promise<ResultType>;
    SetsType(type: string): Promise<ResultType>;
    GetBrushDiameter(): Promise<ResultType>;
    SetBrushDiameter(brushDiameter: number): Promise<ResultType>;
    GetMappingValueRange(): Promise<ResultType>;
    SetMappingValueRange(mappingValueRange: Array<number>): Promise<ResultType>;
    GetColumnarWidth(): Promise<ResultType>;
    SetColumnarWidth(columnarWidth: number): Promise<ResultType>;
    GetMappingHeightRange(): Promise<ResultType>;
    SetMappingHeightRange(mappingHeightRange: Array<number>): Promise<ResultType>;
    GetEnableGap(): Promise<ResultType>;
    SetEnableGap(enableGap: boolean): Promise<ResultType>;
    GetGradientSetting(): Promise<ResultType>;
    SetGradientSetting(gradientSetting: Array<string>): Promise<ResultType>;
    GetFeatures(): Promise<ResultType>;
    SetFeatures(features: Array<IPoint>): Promise<ResultType>;
    GetScheme(): {
        ColumnarHeatMapEntityAtom: ColumnarHeatMapEntityAtomType;
        PointValueAtom: IPointValueAtom;
    };
    GetData(): ColumnarHeatMapType;
    SetData(opt: ColumnarHeatMapType): void;
    generateAtomData(opt: ColumnarHeatMapType): {
        ColumnarHeatMapEntityAtom?: Partial<ColumnarHeatMapEntityAtomType>;
        BasicInfoAtom?: Partial<BasicInfoAtomType>;
        PointValueAtom?: Partial<IPointValueAtom>;
    };
    Clip(polygon: ICoordinates, color?: string): Promise<ResultType>;
    UnClip(): Promise<ResultType>;
}
export default ColumnarHeatMap;
