import { Basic } from './common/basic';
import { ResultType, RotatorType, CoordObjType, IOperations } from './common/data-type';
import { ObjectController } from '../modules/common/object-controller';
import CoveringController from './scene/covering-controller';
import ModelController from './scene/model-controller';
import TilesController from './scene/tiles-controller';
import TilesNodeController from './scene/tilesnode-controller';
import EffectsController from './scene/effects-controller';
import NodeSelectionController from './scene/nodeselection-controller';
import OutlinerController from './scene/outliner-controller';
import GroupController from './scene/group-controller';
import SectionController from './scene/section-controller';
declare class SceneController extends Basic {
    private apiClassName;
    private per;
    Covering: CoveringController;
    Model: ModelController;
    Tiles: TilesController;
    TilesNode: TilesNodeController;
    Effects: EffectsController;
    NodeSelection: NodeSelectionController;
    Outliner: OutlinerController;
    Group: GroupController;
    Section: SectionController;
    private Action;
    private Selection;
    private RequestEntity;
    private Gizmo;
    constructor(obj: any);
    Create(defaultParam: Record<string, any>, batchParams?: Record<string, any>, operations?: IOperations): Promise<ResultType>;
    Delete(objs: Array<Record<string, any>>): Promise<ResultType>;
    Add(obj: Array<Record<string, any>> | Record<string, any>, operations?: IOperations): Promise<ResultType>;
    GetTypesByEids(eids: Array<string>): Promise<ResultType>;
    Clear(EntityTypesToIgnore?: Array<string>): Promise<ResultType>;
    ClearByObjects(objs: Array<Record<string, any>>): Promise<ResultType>;
    SetVisibleByObjects(objs: Array<any>, bVisible?: boolean): Promise<ResultType>;
    private AddAct;
    private AddActMulit;
    RunAction(actionName: string, actionParams: any): Promise<ResultType>;
    EndAction(): Promise<ResultType>;
    GetAction(): Promise<ResultType>;
    AddSelection(objects: Array<any>): Promise<ResultType>;
    RemoveSelection(objects: Array<any>): Promise<ResultType>;
    ClearSelection(): Promise<ResultType>;
    DrawSelection(): Promise<ResultType>;
    GetSelection(): Promise<ResultType>;
    Save(containerId: string): Promise<ResultType>;
    Load(containerId: string): Promise<ResultType>;
    GetObjectEid(eid?: string): Promise<ResultType>;
    GetAll(): Promise<ResultType>;
    Merge(containerId: string, anotherContainerId: string, EntityTypesToIgnore?: never[]): Promise<ResultType>;
    SetLocation(objects: Array<ObjectController>, location: CoordObjType): Promise<ResultType>;
    SetLocations(datas: Array<{
        object: ObjectController;
        location: CoordObjType;
    }>): Promise<ResultType>;
    SetRotator(objects: Array<ObjectController>, rotator: RotatorType): Promise<ResultType>;
    SetRotators(datas: Array<{
        object: ObjectController;
        rotator: RotatorType;
    }>): Promise<ResultType>;
    SetScale3D(objects: Array<ObjectController>, scale3d: CoordObjType): Promise<ResultType>;
    SetScale3Ds(datas: Array<{
        object: ObjectController;
        scale3d: CoordObjType;
    }>): Promise<ResultType>;
    SetVisible(objects: Array<ObjectController>, bVisible?: boolean): Promise<ResultType>;
    Update(objs: Array<Record<string, any>>, opt: Record<string, any>, operations?: IOperations): Promise<ResultType>;
    ClearByCustomId(cids: Array<string>): Promise<ResultType>;
    GetByCustomId(cids: Array<string>): Promise<ResultType>;
    UpdateByCustomId(cids: Array<string>, opt: Record<string, any>): Promise<ResultType>;
    ClearByEntityName(entityNames: Array<string>): Promise<ResultType>;
    GetByEntityName(entityNames: Array<string>): Promise<ResultType>;
    UpdateByEntityName(entityNames: Array<string>, opt: Record<string, any>): Promise<ResultType>;
}
export default SceneController;
