import { Basic } from './common/basic';
import { ResultType } from './common/data-type';
interface eventType {
    name: string;
    func: any;
}
declare class RendererController extends Basic {
    constructor(obj: any);
    Start(): Promise<ResultType>;
    Restart(): Promise<void>;
    Stop(): Promise<void>;
    StartByTaskId(io: string, taskId: string): Promise<ResultType>;
    setResolutionMultiple(multiple?: number): Promise<ResultType>;
    GetMaxFpsRequest(): Promise<void>;
    SetResolution(w: number, h: number): Promise<ResultType>;
    SetFrameRateLimit(maxFPS: number): Promise<ResultType>;
    SetBitrate(bitrate: number): Promise<ResultType>;
    GetStats(): Promise<ResultType>;
    RegisterEvent(events: Array<eventType>): Promise<void>;
    registerSceneEvent(events: Array<eventType>): Promise<void>;
    SetRendererMode(mode: string, resolution?: Array<number>): Promise<void>;
}
export default RendererController;
