import { ObjectAbstract } from '../../../common/object-abstract';
import { ResultType, PolylineType, CoordType, PolylineEntityAtomType, BasicInfoAtomType } from '../../../common/data-type';
import { ObjectController } from '../../../common/object-controller';
declare class Polyline extends ObjectController implements ObjectAbstract {
    className: string;
    private apiClassName;
    private PolylineEntityAtom;
    constructor(opt?: PolylineType);
    get polyline(): {
        points: Array<CoordType>;
    };
    set polyline(polyline: {
        points: Array<CoordType>;
    });
    GetPolyline(): Promise<ResultType>;
    SetPolyline(polyline: {
        points: Array<CoordType>;
    }): Promise<ResultType>;
    GetScheme(): {
        PolylineEntityAtom: PolylineEntityAtomType;
    };
    GetData(): PolylineType;
    SetData(opt: PolylineType): void;
    generateAtomData(opt: PolylineType): {
        PolylineEntityAtom?: Partial<PolylineEntityAtomType>;
        BasicInfoAtom?: Partial<BasicInfoAtomType>;
    };
}
export default Polyline;
