import { ObjectAbstract } from '../../../common/object-abstract';
import { ResultType, Polygon2DType, Polygon2DLoopType, Polygon2DEntityAtomType, BasicInfoAtomType } from '../../../common/data-type';
import { ObjectController } from '../../../common/object-controller';
declare class Polygon2D extends ObjectController implements ObjectAbstract {
    className: string;
    private apiClassName;
    private Polygon2DEntityAtom;
    constructor(opt?: Polygon2DType);
    get polygon(): Polygon2DLoopType;
    set polygon(polygon: Polygon2DLoopType);
    GetPolygon(): Promise<ResultType>;
    SetPolygon(polygon: Polygon2DLoopType): Promise<ResultType>;
    GetScheme(): {
        Polygon2DEntityAtom: Polygon2DEntityAtomType;
    };
    GetData(): Polygon2DType;
    SetData(opt: Polygon2DType): void;
    generateAtomData(opt: Polygon2DType): {
        Polygon2DEntityAtom?: Partial<Polygon2DEntityAtomType>;
        BasicInfoAtom?: Partial<BasicInfoAtomType>;
    };
}
export default Polygon2D;
