import { ObjectBasic } from './object-basic';
import { ResultType, CoordType, RotatorType, ScaleType, TransformAtomType, EntityEidType, BasicInfoAtomType, VisibleAtomType, CacheAtomType, IVisible2D, Visible2DAtomType, IBaseData, IOperations } from './data-type';
export declare class ObjectController extends ObjectBasic implements ObjectAbstract {
    private err;
    isAuth: boolean;
    protected Eid: string | null;
    protected EntityType: string;
    protected objectType: string;
    addNewScheme: Record<string, any>;
    protected BasicInfoAtom: BasicInfoAtomType;
    protected TransformAtom: TransformAtomType;
    protected VisibleAtom: VisibleAtomType;
    protected CacheAtom: CacheAtomType;
    protected Visible2DAtom: Visible2DAtomType;
    constructor();
    get eid(): string | null;
    set eid(Eid: string | null);
    get oType(): string;
    set oType(Type: string);
    get type(): string;
    set type(EntityType: string);
    get bVisible(): boolean;
    set bVisible(bVisible: boolean);
    get entityName(): string;
    set entityName(entityName: string);
    get customId(): string;
    set customId(customId: string);
    get customData(): any;
    set customData(customData: any);
    get location(): CoordType;
    set location(location: CoordType);
    get rotator(): RotatorType;
    set rotator(rotator: RotatorType);
    get scale3d(): ScaleType;
    set scale3d(scale3d: ScaleType);
    get bRemoved(): boolean;
    get hideDistance(): number;
    set hideDistance(hideDistance: number);
    get hideType(): string;
    set hideType(hideType: string);
    get scaleMode(): string;
    set scaleMode(scaleMode: string);
    get clickTop(): boolean;
    set clickTop(clickTop: boolean);
    get hoverTop(): boolean;
    set hoverTop(hoverTop: boolean);
    GetVisible(): Promise<ResultType>;
    SetVisible(bVisible?: boolean): Promise<ResultType>;
    GetEntityName(): Promise<ResultType>;
    SetEntityName(entityName: string): Promise<ResultType>;
    GetCustomId(): Promise<ResultType>;
    SetCustomId(customId: string): Promise<ResultType>;
    GetCustomData(): Promise<ResultType>;
    SetCustomData(customData: any): Promise<ResultType>;
    GetLocation(): Promise<ResultType>;
    SetLocation(location: CoordType): Promise<ResultType>;
    GetRotator(): Promise<ResultType>;
    SetRotator(rotator: RotatorType): Promise<ResultType>;
    GetScale3d(): Promise<ResultType>;
    SetScale3d(scale3d: ScaleType): Promise<ResultType>;
    SetGeometry(geometry: any): Promise<ResultType>;
    GetHideDistance(): Promise<ResultType>;
    SetHideDistance(hideDistance: number): Promise<ResultType>;
    GetHideType(): Promise<ResultType>;
    SetHideType(hideType: string): Promise<ResultType>;
    GetScaleMode(): Promise<ResultType>;
    SetScaleMode(scaleMode: string): Promise<ResultType>;
    GetClickTop(): Promise<ResultType>;
    SetClickTop(clickTop: boolean): Promise<ResultType>;
    GetHoverTop(): Promise<ResultType>;
    SetHoverTop(hoverTop: boolean): Promise<ResultType>;
    GetVisible2DScheme(): {
        Visible2DAtom: Visible2DAtomType;
    };
    GetBasicScheme(): {
        BasicInfoAtom: BasicInfoAtomType;
    };
    GetTransformScheme(): {
        TransformAtom: TransformAtomType;
    };
    GetVisibleScheme(): {
        VisibleAtom: VisibleAtomType;
    };
    GetBaseScheme(): {
        BasicInfoAtom: BasicInfoAtomType;
        TransformAtom: TransformAtomType;
        VisibleAtom: VisibleAtomType;
    };
    GetAllScheme(): any;
    setObj(obj: any, objFactory?: any): void;
    onClick(func: (e: ResultType) => void): void;
    onDbClick(func: (e: ResultType) => void): void;
    onMouseEnter(func: (e: ResultType) => void): void;
    onMouseOut(func: (e: ResultType) => void): void;
    Get(): Promise<ResultType>;
    UpdateBasic(opt: any): Promise<ResultType>;
    Delete(): Promise<ResultType>;
    Update(opt: Record<string, any>, operations?: IOperations): Promise<ResultType>;
    SnapTo(operations: IOperations): Promise<ResultType>;
    DeleteFromCache(bRemoved?: boolean): void;
    SetVisibleCache(bVisible?: boolean): void;
    SetVisible2D(opt: IVisible2D): Promise<ResultType>;
    private handleVisible2DAction;
    private GetVisible2DData;
    private SetVisible2DData;
    private handleVisibleAction;
    private handleLocationAction;
    private handleRotatorAction;
    private handleScale3dAction;
    private handleGeometryAction;
    private handleDeleteAction;
    generateObjectData<T>(atomData: T extends IBaseData ? T : never): void;
    GetData(): Record<string, any>;
    generateLocationAtom(location: CoordType): any;
    generateRotatorAtom(rotator: RotatorType): any;
    generateScale3dAtom(scale3d: ScaleType): any;
    generateVisibleAtom(bVisible: boolean): any;
    protected getOtherData(): Record<string, any>;
    protected setEid(opt: EntityEidType): void;
    protected getEid(): EntityEidType;
    protected setTransformData(opt: Partial<TransformAtomType>): void;
    protected getTransformData(): TransformAtomType;
    protected setBasicData(opt: Partial<BasicInfoAtomType>): void;
    protected getBasicData(): BasicInfoAtomType;
    protected handleBasicAtom(oriData: Record<string, any>, paramsData: Record<string, any>): void;
    protected handleTransformAtom(oriData: Record<string, any>, paramsData: Record<string, any>): void;
}
declare abstract class ObjectAbstract {
    abstract Get: () => Promise<ResultType>;
    abstract Delete: () => Promise<ResultType>;
    abstract SetVisibleCache: (bVisible: boolean) => void;
    abstract DeleteFromCache: (bRemoved: boolean) => void;
    abstract UpdateBasic: (opt: any) => Promise<ResultType>;
    abstract GetVisible: () => Promise<ResultType>;
    abstract SetVisible: (bVisible: boolean) => Promise<ResultType>;
    abstract SetVisible2D: (opt: IVisible2D) => Promise<ResultType>;
    abstract GetEntityName: () => Promise<ResultType>;
    abstract SetEntityName: (entityName: string) => Promise<ResultType>;
    abstract GetCustomId: () => Promise<ResultType>;
    abstract SetCustomId: (customId: string) => Promise<ResultType>;
    abstract GetCustomData: () => Promise<ResultType>;
    abstract SetCustomData: (customData: any) => Promise<ResultType>;
    abstract GetLocation: () => Promise<ResultType>;
    abstract SetLocation: (location: CoordType) => Promise<ResultType>;
    abstract GetRotator: () => Promise<ResultType>;
    abstract SetRotator: (rotator: RotatorType) => Promise<ResultType>;
    abstract GetScale3d: () => Promise<ResultType>;
    abstract SetScale3d: (scale3d: ScaleType) => Promise<ResultType>;
    abstract SetGeometry: (geometry: any) => Promise<ResultType>;
    abstract Update: (opt: any) => Promise<ResultType>;
    abstract generateObjectData: <T>(atomData: T extends IBaseData ? T : never) => void;
    abstract GetData: () => Record<string, any>;
}
export {};
