import { EntityEidType, EntityGeometryType, BasicInfoAtomType, TransformAtomType } from '../data-type';
export interface EffectType extends EntityEidType, EntityGeometryType, Partial<BasicInfoAtomType>, Partial<TransformAtomType>, Partial<EffectsAtomType> {
}
export interface EffectsAtomType {
    bActive: boolean;
    speed: number;
    colorParameters: {
        paramName: {
            r: number;
            g: number;
            b: number;
            a: number;
        };
    };
    vectorParameters: {
        paramName: Array<number>;
    };
    intParameters: {
        paramName: number;
    };
    floatParameters: {
        paramName: number;
    };
    boolParameters: {
        paramName: boolean;
    };
}
