import { EntityEidType, CoordType, BasicInfoAtomType, MinMaxType, Rotator2DType } from '../data-type';
export interface CameraPresetType extends EntityEidType, Partial<BasicInfoAtomType>, Partial<CameraPresetEntityAtomType> {
}
export interface CameraPresetEntityAtomType {
    bDefaultCamera: boolean;
    location: CoordType;
    rotation: Rotator2DType;
    pitchLimit: MinMaxType;
    yawLimit: MinMaxType;
    viewDistanceLimit: MinMaxType;
    fieldOfView: number;
    controlMode: string;
}
export interface CameraControlType {
    targetPosition?: CoordType;
    rotation?: Rotator2DType;
    distance?: number;
    flyTime?: number;
}
export interface CameraFocusType {
    rotation?: Rotator2DType;
    distanceFactor?: number;
    flyTime?: number;
    entity?: Array<any>;
    eids?: Array<string>;
}
export interface CameraFollowType extends EntityEidType {
    entity?: any;
    followRotation?: Rotator2DType;
    useRelativeRotation?: boolean;
    distance?: number;
}
export interface CameraRotateType {
    direction?: string;
    velocity?: number;
}
export interface CameraRoamAtomType {
    frames: Array<any>;
}
export interface CameraRoamType extends EntityEidType, Partial<BasicInfoAtomType>, Partial<CameraRoamAtomType> {
}
