import { Basic } from './basic';
import { AtomAbstract } from './atom-abstract';
import { ResultType, CoordType, RotatorType, ScaleType, BasicInfoAtomType, IOperations, IOBjectCache } from './data-type';
import RequestEntityController from '../action/request-entity-controller';
export declare class AtomController extends Basic implements AtomAbstract {
    private type;
    private ObjectClass;
    protected RequestEntity: RequestEntityController;
    protected objectMap: Map<string, IOBjectCache>;
    constructor(obj: any, ObjectClass?: any);
    protected setType(type: string): void;
    protected generateDataObject<T, S extends Record<string, any>>(params: T, obj: S): S;
    protected findFromMap(key?: string): Map<string, {
        object: Record<string, any>;
    }> | {
        object: Record<string, any>;
    } | undefined;
    addToMap(key: string, obj: any): void;
    protected removeFromMap(key: string): void;
    protected clearMap(): void;
    onClick(func: (e: ResultType) => void): void;
    onDbClick(func: (e: ResultType) => void): void;
    onMouseEnter(func: (e: ResultType) => void): void;
    onMouseOut(func: (e: ResultType) => void): void;
    Delete(eids: Array<string>): Promise<ResultType>;
    SetLocation(eid: string, location: CoordType): Promise<ResultType>;
    SetRotator(eid: string, rotator: RotatorType): Promise<ResultType>;
    SetScale3d(eid: string, scale3d: ScaleType): Promise<ResultType>;
    SetVisible(eids: Array<string>, bVisible?: boolean): Promise<ResultType>;
    ClearCache(): Promise<ResultType>;
    UpdateBasic(eid: string, opt: BasicInfoAtomType): Promise<ResultType>;
    CreateWithTemplate(dp: Record<string, any>, bp: Array<Record<string, any>>, operations?: IOperations): Promise<ResultType>;
    Create(jsonData: any): Promise<ResultType>;
    Add(obj: any, operations?: IOperations): Promise<ResultType>;
    Get(eid?: string): Promise<ResultType>;
    GenerateObject(res: any): Promise<any>;
    GetOnly(eid: string): Promise<ResultType>;
}
