import { ResultType, CoordType, RotatorType, ScaleType, BasicInfoAtomType } from './data-type';
export declare abstract class AtomAbstract {
    abstract Delete: (eids: Array<string>) => Promise<ResultType>;
    abstract SetLocation: (eid: string, location: CoordType) => Promise<ResultType>;
    abstract SetRotator: (eid: string, rotator: RotatorType) => Promise<ResultType>;
    abstract SetScale3d: (eid: string, scale3d: ScaleType) => Promise<ResultType>;
    abstract SetVisible: (eid: Array<string>, bVisible: boolean) => Promise<ResultType>;
    abstract ClearCache: () => Promise<ResultType>;
    abstract UpdateBasic: (eid: string, opt: BasicInfoAtomType) => Promise<ResultType>;
    abstract onClick: (func: any) => void;
    abstract onDbClick: (func: any) => void;
    abstract onMouseEnter: (func: any) => void;
    abstract onMouseOut: (func: any) => void;
    abstract Add: (obj: any) => Promise<ResultType>;
    abstract Get: (eid?: string) => Promise<ResultType>;
    abstract GetOnly: (eid: string) => Promise<ResultType>;
}
