import { AtomController } from './common/atom-controller';
import { ResultType } from './common/data-type';
import { CameraPresetType, CameraControlType, CameraFocusType, CameraFollowType, CameraRotateType } from './common/interface/camera';
declare class CameraControlController extends AtomController {
    private controllerName;
    constructor(obj: any);
    GetCameraInfo(): Promise<ResultType>;
    UpdateCamera(opt: CameraPresetType): Promise<ResultType>;
    FlyTo(opt: CameraControlType): Promise<ResultType>;
    Move(opt: CameraRotateType): Promise<ResultType>;
    Focus(opt: CameraFocusType): Promise<ResultType>;
    FocusToAll(): Promise<ResultType>;
    Follow(opt: CameraFollowType): Promise<ResultType>;
    Stop(): Promise<ResultType>;
    Rotate(opt: CameraRotateType): Promise<ResultType>;
    Around(opt: CameraRotateType): Promise<ResultType>;
    PlayCameraRoam(obj: any): Promise<ResultType>;
    Apply(camera: any, flyTime?: number): Promise<ResultType>;
    FocusByCustomId(cids: Array<string>, opt: CameraFocusType): Promise<ResultType>;
    FocusByEntityName(entityNames: Array<string>, opt: CameraFocusType): Promise<ResultType>;
}
export default CameraControlController;
