import { ObjectAbstract } from '../common/object-abstract';
import { ResultType, MinMaxType, Rotator2DType, CoordType, BasicInfoAtomType } from '../common/data-type';
import { CameraPresetType, CameraPresetEntityAtomType } from '../common/interface/camera';
import { ObjectController } from '../common/object-controller';
declare class Camera extends ObjectController implements ObjectAbstract {
    className: string;
    private CameraPresetEntityAtom;
    constructor(opt?: CameraPresetType);
    get location(): CoordType;
    set location(location: CoordType);
    get rotation(): Rotator2DType;
    set rotation(rotation: Rotator2DType);
    get pitchLimit(): MinMaxType;
    set pitchLimit(pitchLimit: MinMaxType);
    get yawLimit(): MinMaxType;
    set yawLimit(yawLimit: MinMaxType);
    get viewDistanceLimit(): MinMaxType;
    set viewDistanceLimit(viewDistanceLimit: MinMaxType);
    get fieldOfView(): number;
    set fieldOfView(fieldOfView: number);
    get controlMode(): string;
    set controlMode(controlMode: string);
    GetLocation(): Promise<ResultType>;
    SetLocation(location: CoordType): Promise<ResultType>;
    GetRotation(): Promise<ResultType>;
    SetRotation(rotation: Rotator2DType): Promise<ResultType>;
    GetPitchLimit(): Promise<ResultType>;
    SetPitchLimit(pitchLimit: MinMaxType): Promise<ResultType>;
    GetYawLimit(): Promise<ResultType>;
    SetYawLimit(yawLimit: MinMaxType): Promise<ResultType>;
    GetViewDistanceLimit(): Promise<ResultType>;
    SetViewDistanceLimit(viewDistanceLimit: MinMaxType): Promise<ResultType>;
    GetFieldOfView(): Promise<ResultType>;
    SetFieldOfView(fieldOfView: number): Promise<ResultType>;
    GetControlMode(): Promise<ResultType>;
    SetControlMode(controlMode: string): Promise<ResultType>;
    GetScheme(): {
        CameraPresetEntityAtom: CameraPresetEntityAtomType;
    };
    GetData(): CameraPresetType;
    SetData(opt: CameraPresetType): void;
    generateAtomData(opt: CameraPresetType): {
        CameraPresetEntityAtom?: Partial<CameraPresetEntityAtomType>;
        BasicInfoAtom?: Partial<BasicInfoAtomType>;
    };
}
export default Camera;
