import CloudApi from 'cloudapi';
import RendererController from './modules/renderer-controller';
import DebugController from './modules/debug-controller';
import EnvironmentController from './modules/environment-controller';
import SystemController from './modules/system-controller';
import ToolsController from './modules/tools-controller';
import CustomizeController from './modules/customize-controller';
import SettingController from './modules/setting-controller';
import DataModelController from './modules/datamodel-controller';
import SceneController from './modules/scene-controller';
import CameraControlController from './modules/cameracontrol-controller';
import CameraPresetController from './modules/camerapreset-controller';
import CameraRoamControllerController from './modules/cameraroam-controller';
import TransactionController from './modules/transaction-controller';
import PluginController from './modules/plugin-controller';
import CameraObject from './modules/camera/index';
import CameraRoamObject from './modules/camera-roam/index';
import PointObject from './modules/data-model/geometry/point/index';
import PolylineObject from './modules/data-model/geometry/polyline/index';
import Polygon2DObject from './modules/data-model/geometry/polygon2d/index';
import RangeObject from './modules/scene/covering/range/index';
import PoiObject from './modules/scene/covering/poi/index';
import PathObject from './modules/scene/covering/path/index';
import HeatMapObject from './modules/scene/covering/heatmap/index';
import HighlightAreaObject from './modules/scene/covering/highlightarea/index';
import ParticleObject from './modules/scene/covering/particle/index';
import Text3DObject from './modules/scene/covering/text3d/index';
import ColumnarHeatMapObject from './modules/scene/covering/columnarheatmap/index';
import WindowObject from './modules/scene/covering/window/index';
import ViewshedObject from './modules/scene/covering/viewshed/index';
import ParabolaObject from './modules/scene/covering/parabola/index';
import BoundObject from './modules/scene/covering/bound/index';
import TilesObject from './modules/scene/tiles/index';
import StaticObject from './modules/scene/model/static/index';
import HierarchyObject from './modules/scene/model/hierarchy/index';
import SkeletalObject from './modules/scene/model/skeletal/index';
import SpaceHeatMapObject from './modules/scene/covering/spaceheatmap/index';
import RoadHeatMapObject from './modules/scene/covering/roadheatmap/index';
import RasterObject from './modules/scene/covering/raster/index';
import RealTimeVideoObject from './modules/scene/covering/realtimevideo/index';
import GroupObject from './modules/scene/group/index';
interface CloudApiType {
    id: string;
    lock?: boolean;
    fullscreen?: boolean;
    debugMode?: string;
    resolution?: Array<number>;
    keyboard?: {
        normal?: boolean;
        func?: boolean;
    };
    initLog?: boolean;
    rendererMode?: string;
}
interface InnerType {
    fingerprint?: string;
}
interface WdpApiType extends CloudApiType, InnerType {
    url: string;
    order: string;
}
export default class WdpApi extends CloudApi {
    private recordMode;
    private apiInfo;
    private record;
    private ws;
    private _P;
    private apiRequestMode;
    private apiRequestURL;
    private timeoutTime;
    private ObjectEidMap;
    private RegisterObj;
    private url;
    private order;
    private UeEvents;
    private reqMan;
    private EventList;
    private RequestEntity;
    Renderer: RendererController;
    Debug: DebugController;
    Environment: EnvironmentController;
    System: SystemController;
    Tools: ToolsController;
    Customize: CustomizeController;
    Setting: SettingController;
    DataModel: DataModelController;
    Scene: SceneController;
    CameraControl: CameraControlController;
    CameraPreset: CameraPresetController;
    CameraRoamController: CameraRoamControllerController;
    Transaction: TransactionController;
    Plugin: PluginController;
    Camera: typeof CameraObject;
    CameraRoam: typeof CameraRoamObject;
    Point: typeof PointObject;
    Polyline: typeof PolylineObject;
    Polygon2D: typeof Polygon2DObject;
    Range: typeof RangeObject;
    Poi: typeof PoiObject;
    Path: typeof PathObject;
    HeatMap: typeof HeatMapObject;
    HighlightArea: typeof HighlightAreaObject;
    Particle: typeof ParticleObject;
    Text3D: typeof Text3DObject;
    ColumnarHeatMap: typeof ColumnarHeatMapObject;
    Window: typeof WindowObject;
    Viewshed: typeof ViewshedObject;
    Parabola: typeof ParabolaObject;
    Bound: typeof BoundObject;
    Tiles: typeof TilesObject;
    Static: typeof StaticObject;
    Hierarchy: typeof HierarchyObject;
    Skeletal: typeof SkeletalObject;
    SpaceHeatMap: typeof SpaceHeatMapObject;
    RoadHeatMap: typeof RoadHeatMapObject;
    Raster: typeof RasterObject;
    RealTimeVideo: typeof RealTimeVideoObject;
    Group: typeof GroupObject;
    constructor(opt: WdpApiType);
    private init;
    private initLog;
    /**
     * @function registerSceneEvent
     * @param {Array[{name: string, func: any}]} [events]
     * @return {void}
     */
    private registerSceneEvent;
    private setLogLevel;
    /**
     * @function startCloud
     * @return {Promise<void>}
     */
    private startCloud;
    private startCloudByTaskId;
    private startSocketDebugMode;
    /**
     * @function startApi
     * @param {any} [data] Json data
     * @return {Promise<any>}
     */
    private startApi;
    /**
     * @function startApiByObject
     * @param {any} [data] Json data
     * @return {Promise<any>}
     */
    private startApiByObject;
    /**
     * @function handleDataChannelMessage
     * @param {any} [data] datachannel data
     * @return {void}
     */
    private handleDataChannelMessage;
    /**
     * @function handleApiData
     * @param {any} [jsonData]
     * @return {void}
     */
    private handleApiData;
    /**
     * @function handleUEEventData
     * @param {any} [jsonData]
     * @return {void}
     */
    private handleUEEventData;
    /**
     * @function handleErrorData
     * @param {any} [jsonData]
     * @return {void}
     */
    private handleErrorData;
    /**
     * @function handleDefaultData
     * @param {any} [jsonData]
     * @return {void}
     */
    private handleDefaultData;
    private OnWdpSceneIsReady;
    private OnEntityClicked;
    private OnEntityDbClicked;
    private OnMouseEnterEntity;
    private OnMouseOutEntity;
    private OnEntityNodeSelectionChanged;
    private OnEntitySelectionChanged;
    private OnEntityAdded;
    private OnEntityRemoved;
    private OnEntityUpdated;
    private OnWdpSceneChanged;
}
export {};
