## Introduction

GisApi is a gis plugin for WdpApi


#### Install
```bash
$ npm i gisapi
```

#### Import
```javascript
import WdpApi from 'wdpapi'
import GisApi from 'gisapi'
```

#### Init
```javascript
const config = {
    "id": "player", //[required] Render scene container(DOM node id)
    "url": "http://172.31.19.235:8889/Renderers/Any/order", //[optional] Cloud rendering service address
    "order": "b96285A3", //[optional] Rendering order, obtained on the cloud rendering client
    "resolution": [3840,2160], //[optional] Set the cloud rendering output resolution[width, height]
    "debugMode": "normal", //[optional] none: does not print logs, normal: normal logs
    "keyboard": { //[optional] keyboard event
        "normal": false, //[optional] Keyboard event, exclude F1~F12 [default disabled]
        "func": false //[optional] Browser F1 ~ F12 function keys [default disabled]
    }
}
const App = new WdpApi(config) as GisApi & WdpApi;
App.Plugin.Install(GisApi).then(r=>{
    App.Renderer.Start().then((res) => {
        if (res.success) {
            App.Renderer.RegisterEvent([
                {
                    name: 'onVideoStreamLoaded', func: function () {
                        // 视频流加载成功
                    }
                }
            ])
        }
    })
});
```

#### Methods
```javascript
/** 通用 API, 支持3DTiles/WMS/WMTS三种图层及偏移 **/
const gisLayer = new App['3DTiles/WMS/WMTS']({
    'configs':{
        "url": "https://gis-demo-data.51aes.com:50000/model/GSZ/tileset.json",
        "offset": [ 0, 0, 0 ]
    }
})
const res = await App.Scene.Add(gisLayer)

gisLayer.Update(
    {
        'configs':{
            "offset": [ 10, 10, 20 ]
        }
    }
)

gisLayer.Delete()

/** 请注意以下配置需要专业版支持 **/
const geoLayerConfig = {
    "geoLayerUrl": "GDAL/bj/BJ_bud_02_Elevation.shp",
    "geoLayerType": "shp",
    "geoLayerParams":
        {
            "serviceLayerName": "",
            "featureType": "Polygon",
            "needGCJOffset": false,
            "batchFeatureNum": 4000
        },
    "geoFeatureStyle":{
        "styleDesc": "Default1",
        "bBasedOnTerrain": false,
        "PolygonStyle":
            {
                "filledColor": "#FF0000FF",
                "bOutline": false,
                "outlineColor": "#00C0C8FF",
                "outlineWidth": 200,
                "bExtrude": true,
                "extrudeHeight": 100,
                "extrudeHeightField": "Elevation"
            },
        "lineStyle":
            {
                "lineColor": "#00C0C8FF",
                "lineWidth": 10,
                "lineShape": "Plane"
            }
    }
}

/** 加载矢量图层 **/
const geoLayer = new App.GeoLayer(geoLayerConfig)
await App.Scene.Add(geoLayer)

/** 图层点击事件 **/
geoLayer.onClick((result: any, obj:any)=>{
    console.log(result, obj)
})

/** 获取图层信息 **/
geoLayer.GetGeoLayerInfo()

/** 执行图层操作 **/
geoLayer.RunGeoLayerAction({
    "actionName": "",
    "featureId": "",
})

/** 设置图层参考点 **/
geoLayer.SetLocalGeoreference({
    "geoReference": [ 121.46694444000001, 31.235277780000001 ]
})

/** 设置图层高度 **/
geoLayer.SetGeoLayerHeight({
    "geoLayerIndex": 0,
    "geoLayerHeightOffset": 5
})

/** 设置图层位置 **/
geoLayer.SetGeoLayerLocation({
    "geoLayerLocation": [ 0, 0, 0 ],
})

/** 获取图层位置 **/
geoLayer.GetGeoLayerLocation()
```

#### Stop Rendering
```javascript
App.Renderer.Stop();
```

## License

Copyright (c) 2023-present, 51WORLD
