import { ObjectController } from "../../../modules/common/object-controller";
import { EntityEidType, EntityGeometryType, BasicInfoAtomType, TransformAtomType } from '../../../../src/modules/common/data-type';
interface ResultType {
    success: boolean;
    message?: string;
    result?: any;
}
export interface IGeoLayerObjectClass extends EntityEidType, EntityGeometryType, Partial<BasicInfoAtomType>, Partial<TransformAtomType> {
    clickFun: void | undefined;
    configs: {
        geoLayerUrl: string;
        geoLayerType: string;
        geoLayerParams?: any;
        geoFeatureStyle?: any;
        geoLayerSymbol?: any;
    };
    offset?: any;
    GetGeoLayerInfo(): Promise<ResultType>;
    RunGeoLayerAction(opt: Record<string, any>): Promise<ResultType>;
    SetLocalGeoreference(opt: Record<string, any>): Promise<ResultType>;
    SetGeoLayerHeight(opt: Record<string, any>): Promise<ResultType>;
    SetGeoLayerLocation(opt: Record<string, any>): Promise<ResultType>;
    GetGeoLayerLocation(opt: Record<string, any>): Promise<ResultType>;
    execute(apiName: string, opt: Record<string, any>, cb?: () => void): Promise<ResultType>;
}
export default class GeoLayerObject {
    static instance: GeoLayerObject;
    static getInstance(obj?: any | undefined): GeoLayerObject;
    static ObjectCore(extendClass: typeof ObjectController): any;
}
export {};
