import Core from "./core";
import { ObjectController } from "@/modules/common/object-controller";
import { IWmsType } from "@/plugins/gis/modules/module-wms";
import { IWmtsType } from "@/plugins/gis/modules/module-wmts";
import { I3DTilesType } from "@/plugins/gis/modules/module-3DTiles";
type GisApiType = GisApi;
export type { GisApiType };
type WMSWithObjectClass = ObjectController & IWmsType;
type WMTSWithObjectClass = ObjectController & IWmtsType;
type ThreeDTilesObjectClass = ObjectController & I3DTilesType;
export default class GisApi {
    obj: any;
    Core: Core;
    static instance: GisApi;
    WMS: new (config: Record<any, any>) => WMSWithObjectClass;
    WMTS: new (config: Record<any, any>) => WMTSWithObjectClass;
    '3DTiles': new (config: Record<any, any>) => ThreeDTilesObjectClass;
    constructor(obj?: any);
    static getInstance(): GisApi;
    private OnGeoLayerFeatureClicked;
    install(): Promise<Record<'list', any>>;
}
