import { I3DTilesType } from "../modules/module-3DTiles";
import { IWmsType } from "../modules/module-wms";
import { IWmtsType } from "../modules/module-wmts";
import { AtomController } from "@/modules/common/atom-controller";
import { ObjectController } from "@/modules/common/object-controller";
export default class Core {
    ControllerCore?: typeof AtomController;
    ObjectCore?: typeof ObjectController;
    GeoLayerControllerCore?: typeof AtomController;
    GeoLayerObjectCore?: typeof ObjectController & I3DTilesType;
    ThreeDTilesControllerCore?: typeof AtomController;
    ThreeDTilesObjectCore?: typeof ObjectController & I3DTilesType;
    WMSControllerCore?: typeof AtomController;
    WMSObjectCore?: typeof ObjectController & IWmsType;
    WMTSControllerCore?: typeof AtomController;
    WMTSObjectCore?: typeof ObjectController & IWmtsType;
    static instance: Core;
    static getInstance(obj?: any | undefined): Core;
    genObjectCore(): void;
    genControllerCore(): void;
}
